/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.BaseBlock;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.util.List;

public abstract class VariableConnectorBaseBlock
extends BaseBlock {
    static final long serialVersionUID = -2104684703767569714L;
    private int onDelayBlockSerializedDataVersion = 1;

    public VariableConnectorBaseBlock() {
    }

    public VariableConnectorBaseBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected void initInConnectors() {
        int inConnectorCount = 0;
        WiringDiagram wd = this.getWiringDiagram();
        if (wd != null) {
            inConnectorCount = wd.getHardware().supports("4BaseBlockInputs") ? 4 : 3;
        }
        this.fInConnectors = new InBlockConnector[inConnectorCount];
        for (int i = 0; i < inConnectorCount; ++i) {
            this.fInConnectors[i] = new BinaryInBlockConnector(this, this.getDefaultInConnectorValue(), Integer.toString(i + 1));
        }
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        int newConnectorCount = ((Hardware)hardwareChangedEvent.getNewValue()).supports("4BaseBlockInputs") ? 4 : 3;
        int connectorCount = this.getInConnectorCount();
        if (newConnectorCount != connectorCount) {
            BinaryInBlockConnector[] arr = null;
            if (newConnectorCount > connectorCount) {
                arr = new BinaryInBlockConnector[newConnectorCount];
                System.arraycopy(this.fInConnectors, 0, arr, 0, connectorCount);
                for (int i = connectorCount; i < arr.length; ++i) {
                    arr[i] = new BinaryInBlockConnector(this, this.getDefaultInConnectorValue(), Integer.toString(i + 1));
                }
                this.fInConnectors = arr;
            } else {
                arr = new BinaryInBlockConnector[newConnectorCount];
                System.arraycopy(this.fInConnectors, 0, arr, 0, newConnectorCount);
            }
            this.fInConnectors = arr;
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "inConnector"));
        }
    }

    protected abstract boolean getDefaultInConnectorValue();

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = true;
        if (this.getInConnectorCount() > 3 && this.getInConnector(3).getLinkedConnectorsCount() > 0 && !(result = hw.supports("4BaseBlockInputs"))) {
            errorList.add(new ErrorInfo(this, "error.convert.4inputs", hw));
        }
        return result && super.isAvailable(hw, errorList);
    }
}

